#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

#define SOCKET_PATH "/tmp/socket.domain"

void err_quit(const char* estr) {
    perror(estr);
    exit(-1);
}
int main(int argc, char* argv[]) {
    char buf[1024]; // 用于存储从客户端读取的数据
    int i;
    int listen_fd = -1;                   // 监听套接字
    int client_fd;                        // 客户端套接字
    int rv = -1;                          // 读取返回值
    struct sockaddr_un servaddr;          // 服务器地址结构
    struct sockaddr_un cliaddr;           // 客户端地址结构
    socklen_t addrlen = sizeof(servaddr); // 地址长度

    // 创建Unix域套接字
    listen_fd = socket(AF_UNIX, SOCK_STREAM, 0);
    if(listen_fd < 0) {
        err_quit("socket create fail"); // 创建套接字失败
    }

    printf("create sockfd[%d] ok!\n", listen_fd); // 创建套接字成功

    // 如果套接字路径已存在，则删除
    if(!access(SOCKET_PATH, F_OK)) {
        remove(SOCKET_PATH);
    }

    // 清零服务器地址结构
    bzero(&servaddr, addrlen);

    servaddr.sun_family = AF_UNIX;                                      // 设置地址族为Unix域
    strncpy(servaddr.sun_path, SOCKET_PATH, sizeof(servaddr.sun_path)); // 设置套接字路径

    // 绑定套接字到地址
    if(bind(listen_fd, (struct sockaddr*)&servaddr, addrlen) < 0) {
        printf("Create socket failure:%s\n", strerror(errno)); // 绑定失败
        unlink(SOCKET_PATH);
        return -1;
    }

    // 监听套接字
    listen(listen_fd, 13);

    // 无限循环等待客户端连接
    while(1) {
        printf("Start waiting and accept new client connect......\n");       // 等待客户端连接
        client_fd = accept(listen_fd, (struct sockaddr*)&cliaddr, &addrlen); // 接受客户端连接
        if(client_fd < 0) {
            printf("Accept new client failure:%s\n", strerror(errno)); // 接受连接失败
            return -2;
        }

        memset(buf, 0, sizeof(buf)); // 清空缓冲区

        // 从客户端读取数据
        if((rv = read(client_fd, buf, sizeof(buf))) < 0) {
            printf("Read from client[%d] failure:%s\n", client_fd, strerror(errno)); // 读取失败
            close(client_fd);
            continue;
        }

        else if(rv == 0) {
            printf("socket connet disconneted\n"); // 客户端断开连接
            close(client_fd);
            continue;
        }

        printf("Read massage from client[%d]:%s\n", listen_fd, buf); // 打印从客户端读取的消息

        // 将读取的数据转换为大写
        for(i = 0; i < rv; i++) {
            buf[i] = toupper(buf[i]);
        }

        // 向客户端写入数据
        if(write(client_fd, buf, rv) < 0) {
            printf("Write to client[%d] failure:%s\n", client_fd, strerror(errno)); // 写入失败
            close(client_fd);
            continue;
        }

        printf("Write %d bytes data to client[%d]\n", rv - 1, client_fd); // 打印写入客户端的数据量

        close(client_fd); // 关闭客户端套接字

        sleep(1); // 暂停1秒
    }

    close(listen_fd); // 关闭监听套接字
}
