#include <iostream>
#include "net.h"

using namespace sccl;

int main(int argc, char* argv[]) {
    INFO(SCCL_LOG_CODEALL, "Hello, World!");
    // SCCLCHECK(scclSystemError);
    // SCCLCHECK(sccl::hardware::net::device::scclIbInit());
    // SCCLCHECK(sccl::hardware::net::device::scclIbGetDevicesNum(&n_ib));
    // printf("device num=%d\n", n_ib);

    // ----------------------------------------------------------------------- //
    sccl::hardware::net::scclNet_t* scclNet;
    sccl::hardware::net::scclNetInit("IB", scclNet);
    // sccl::hardware::net::scclNetInit("Socket", scclNet);
    scclNet->init();
    int n_ib;
    scclNet->devices(&n_ib);
    printf("device num=%d\n", n_ib);

    sccl::hardware::net::scclNetProperties_t props;
    scclNet->getProperties(0, &props);

    printf("device name=%s\n", props.name);
    printf("device pciPath=%s\n", props.pciPath);
    printf("device guid=%lu\n", props.guid);
    printf("device ptrSupport=%d\n", props.ptrSupport);
    printf("device speed=%d\n", props.speed);
    printf("device port=%d\n", props.port);
    printf("device latency=%f\n", props.latency);
    printf("device maxComms=%d\n", props.maxComms);
    printf("device maxRecvs=%d\n", props.maxRecvs);

    // 程序成功执行，返回0
    return 0;
}

// HIP_VISIBLE_DEVICES=1 ./1_simple
