#include <hip/hip_runtime.h>
#include <iostream>

int main() {
    int deviceCount     = 0;
    hipError_t error_id = hipGetDeviceCount(&deviceCount);

    if(error_id != hipSuccess) {
        std::cerr << "Error: " << hipGetErrorString(error_id) << std::endl;
        return EXIT_FAILURE;
    }

    if(deviceCount == 0) {
        std::cerr << "There are no available GPU devices." << std::endl;
        return EXIT_FAILURE;
    }

    for(int dev = 0; dev < deviceCount; ++dev) {
        hipDeviceProp_t deviceProp;
        hipError_t err = hipGetDeviceProperties(&deviceProp, dev);
        if(err != hipSuccess) {
            std::cerr << "Error getting device properties for device " << dev << ": " << hipGetErrorString(err) << std::endl;
            continue; // 或者根据需要处理错误，例如跳过这个设备或终止程序
        }

        std::cout << "Device " << dev << ": " << deviceProp.name << std::endl;
        std::cout << "  GCN Arch: " << deviceProp.gcnArchName << std::endl;
        std::cout << "  Compute Capability: " << deviceProp.major << "." << deviceProp.minor << std::endl;
        std::cout << "  Total Global Mem: " << deviceProp.totalGlobalMem << " bytes" << std::endl;
        std::cout << "  Total Const Mem: " << deviceProp.totalConstMem << " bytes" << std::endl;
        std::cout << "  Max Threads Per Block: " << deviceProp.maxThreadsPerBlock << std::endl;
        // 你可以根据需要打印更多的设备属性
    }

    return EXIT_SUCCESS;
}
