#ifndef ARCHINFO_H_
#define ARCHINFO_H_

#include <string.h>

/*
#include <hip/hip_runtime_api.h>
#include <hip/hip_runtime.h>
*/

namespace sccl {

// 将GCN架构名称格式化为指定的输出格式
void GcnArchNameFormat(char* gcnArchName, char* out);

// 将GCN架构转换为GCN架构名称
void convertGcnArchToGcnArchName(const char* gcnArch, const char** gcnArchName);

// 获取指定设备ID的GCN架构名称
int GetGcnArchName(int deviceId, char* out);

// 获取指定设备ID的设备墙钟速率（以KHz为单位）
double GetDeviceWallClockRateInKhz(int deviceId);

// 判断指定的架构名称是否与目标架构匹配
bool IsArchMatch(char const* arch, char const* target);
} // namespace sccl

#endif // ARCHINFO_H_
