#pragma once

#include <string.h>
#include "base.h"

namespace sccl {
namespace hardware {
namespace topology {

// 定义硬件拓扑类型枚举
typedef enum topoNodeType {
    GPU = 0, // 图形处理单元
    PCI = 1, // 外围组件互连
    NVS = 2, // 非易失性存储器
    CPU = 3, // 中央处理器，实际上是NUMA域
    NIC = 4, // 网络接口控制器
    NET = 5  // 网络
} topoNodeType_t;

// 定义 topoPathType_t 枚举类型，用于表示不同的路径类型。
enum topoPathType {
    PATH_LOC = 0, // 本地路径
    PATH_NVL = 1, // 通过 NVLink 连接
    PATH_NVB = 2, // 通过中间 GPU 使用 NVLink 连接
    PATH_PIX = 3, // 通过最多一个 PCIe 桥连接
    PATH_PXB = 4, // 通过多个 PCIe 桥连接（不经过 PCIe 主桥）
    PATH_PXN = 5, // GPU 和 NIC 之间通过中间 GPU 连接
    PATH_PHB = 6, // 通过 PCIe 以及 PCIe 主桥连接
    PATH_SYS = 7, // 通过 PCIe 以及 NUMA 节点之间的 SMP 互连连接
    PATH_NET = 8, // 通过网络连接
    PATH_DIS = 9  // 断开连接
};

////////////////////////////////////////////////////////////////////////////////////////////////

// 将64位整数转换为总线ID字符串
scclResult_t int64ToBusId(int64_t id, char* busId);

// 将总线ID字符串转换为64位整数
scclResult_t busIdToInt64(const char* busId, int64_t* id);

// 将PCI路径转换为64位整数，路径偏移量和最小偏移量作为参数
scclResult_t pciPathToInt64(char* path, int offset, int minOffset, int64_t* id);

} // namespace topology
} // namespace hardware
} // namespace sccl
