#include <string.h>
#include "topo_utils.h"
// #include "net.h"
// #include "xml.h"
// #include "net.h"

namespace sccl {
namespace hardware {
namespace topology {

scclResult_t int64ToBusId(int64_t id, char* busId) {
    sprintf(busId, "%04lx:%02lx:%02lx.%01lx", (id) >> 20, (id & 0xff000) >> 12, (id & 0xff0) >> 4, (id & 0xf));
    return scclSuccess;
}

scclResult_t busIdToInt64(const char* busId, int64_t* id) {
    char hexStr[17]; // Longest possible int64 hex string + null terminator.
    int hexOffset = 0;
    for(int i = 0; hexOffset < sizeof(hexStr) - 1; i++) {
        char c = busId[i];
        if(c == '.' || c == ':')
            continue;
        if((c >= '0' && c <= '9') || (c >= 'A' && c <= 'F') || (c >= 'a' && c <= 'f')) {
            hexStr[hexOffset++] = busId[i];
        } else
            break;
    }
    hexStr[hexOffset] = '\0';
    *id               = strtol(hexStr, NULL, 16);
    return scclSuccess;
}

scclResult_t pciPathToInt64(char* path, int offset, int minOffset, int64_t* id) {
    char* str = path + offset;
    // Remove trailing "/"
    if(*str == '/')
        str--;
    // Find next /
    while(*str != '/')
        str--;
    str++;
    int64_t numid;
    SCCLCHECK(busIdToInt64(str, &numid));
    // Ignore subdevice because those should use the same PCI link so we want to merge nodes.
    numid -= numid & 0xf;
    *id = numid;
    return scclSuccess;
}

} // namespace topology
} // namespace hardware
} // namespace sccl
