#pragma once

#include <stdio.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <unistd.h>
#include <errno.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <memory.h>
#include <sys/un.h>
#include <inttypes.h>

#include "base.h"

namespace sccl {
namespace hardware {
namespace topology {
namespace bootstrap {
#define SCCL_IPC_SOCKNAME_LEN 64

// 定义IPC套接字结构体
struct scclIpcSocket {
    int fd;                                 // 文件描述符
    char socketName[SCCL_IPC_SOCKNAME_LEN]; // 套接字名称
    volatile uint32_t* abortFlag;           // 用于中止操作的标志
};

// 初始化IPC套接字
scclResult_t scclIpcSocketInit(struct scclIpcSocket* handle, int rank, uint64_t hash, volatile uint32_t* abortFlag);

// 关闭IPC套接字
scclResult_t scclIpcSocketClose(struct scclIpcSocket* handle);

// 接收文件描述符
scclResult_t scclIpcSocketRecvFd(struct scclIpcSocket* handle, int* fd);

// 发送文件描述符
scclResult_t scclIpcSocketSendFd(struct scclIpcSocket* handle, const int fd, int rank, uint64_t hash);

} // namespace bootstrap
} // namespace topology
} // namespace hardware
} // namespace sccl
