#pragma once

#include <string.h>
#include "base.h"
#include "ipcsocket.h"
#include "proxy.h"

namespace sccl {
namespace hardware {
namespace topology {
namespace bootstrap {

typedef net::host::scclSocketAddress scclSocketAddress_t;
typedef net::host::scclSocket scclSocket_t;

// scclBootstrapHandle 结构体定义，用于存储引导句柄
struct scclBootstrapHandle {
    uint64_t magic;           // 魔术数，用于标识结构体的有效性
    scclSocketAddress_t addr; // 地址，用于网络通信
};

struct scclProxyState {
    int refCount;      // 引用计数
    int tpRank;        // 当前线程的排名
    int tpnRanks;      // 线程组中线程的总数
    int tpLocalnRanks; // 本地线程组中线程的总数

    int cudaDev;                       // CUDA设备编号
    int p2pnChannels;                  // 点对点通信的通道数
    int p2pChunkSize;                  // 点对点通信的数据块大小
    int nChannels;                     // 通道总数
    int buffSizes[SCCL_NUM_PROTOCOLS]; // 各种协议的缓冲区大小

    // 服务线程
    pthread_t thread;         // 线程ID
    scclSocket_t* listenSock; // 监听套接字
    int stop;                 // 停止标志

    // 由主线程使用
    scclSocketAddress_t* peerAddresses; // 对等体地址
    scclSocket_t* peerSocks;            // 对等体套接字
    struct scclIpcSocket peerIpcSock;   // cuMEM API支持（UDS）

    // 进展线程
    struct scclProxyProgressState progressState; // 进展状态

    // 从代理预期的响应队列
    struct scclExpectedProxyResponse* expectedResponses; // 预期的代理响应
};

// scclBootstrapComm 结构体定义，用于存储引导通信信息
struct scclBootstrapComm {
    struct scclUniqueInfo unique_info; // 每个通信节点的基础信息

    void* bootstrap;              // 引导信息
    uint64_t magic;               // 魔术数，用于验证结构体
    volatile uint32_t* abortFlag; // 中止标志
    int splitShare;               // 是否使用共享内存进行分割
    int* topParentRanks;          // 顶级父节点的rank
    /* 与代理相关的共享资源 */
    struct scclProxyState* proxyState;
};

// extInfo 结构体定义，用于存储Socket扩展信息
struct extInfo {
    int rank;                                 // 进程排名
    int nranks;                               // 进程总数
    scclSocketAddress_t extAddressListenRoot; // 根监听地址
    scclSocketAddress_t extAddressListen;     // 监听地址
};

struct unexConn {
    int peer;              // 对等节点的标识符
    int tag;               // 连接的标签，用于区分不同的连接
    scclSocket_t sock;     // 套接字结构，用于网络通信
    struct unexConn* next; // 指向下一个未建立连接的指针，形成链表结构
};

// bootstrapState 结构体定义，用于存储引导状态
struct bootstrapState {
    scclSocket_t listenSock;                 // 监听套接字
    scclSocket_t ringRecvSocket;             // 环接收套接字
    scclSocket_t ringSendSocket;             // 环发送套接字
    scclSocketAddress_t* peerCommAddresses;  // 对等通信地址
    scclSocketAddress_t* peerProxyAddresses; // 对等代理地址
    struct unexConn* unexpectedConnections;  // 意外连接
    int cudaDev;                             // CUDA 设备编号
    int rank;                                // 进程排名
    int nranks;                              // 进程总数
    uint64_t magic;                          // 魔术数，用于验证结构体
    volatile uint32_t* abortFlag;            // 中止标志
};

} // namespace bootstrap
} // namespace topology
} // namespace hardware
} // namespace sccl
