#pragma once

#include <string.h>
#include "base.h"
#include "socket.h"
#include "bootstrap_utils.h"

namespace sccl {
namespace hardware {
namespace topology {
namespace bootstrap {

template <typename Int>
inline void scclAtomicRefCountIncrement(Int* refs) {
    __atomic_fetch_add(refs, 1, __ATOMIC_RELAXED);
}

////////////////////////////////////////////////////////////////////////////////////////////////
namespace bootstrap_net {
// 通过socket发送数据
scclResult_t bootstrapNetSend(scclSocket_t* sock, void* data, int size);
// 通过socket接收数据
scclResult_t bootstrapNetRecv(scclSocket_t* sock, void* data, int size);
// 初始化网络引导
scclResult_t bootstrapNetInit();
} // namespace bootstrap_net

// 将消息加入到未预期消息队列中
scclResult_t unexpectedEnqueue(struct bootstrapState* state, int peer, int tag, scclSocket_t* sock);
// 从未预期消息队列中取出消息
scclResult_t unexpectedDequeue(struct bootstrapState* state, int peer, int tag, scclSocket_t* sock, int* found);
// 释放未预期消息队列中的资源
static void unexpectedFree(struct bootstrapState* state);

// 执行全节点数据收集操作
scclResult_t bootstrapAllGather(void* commState, void* allData, int size);
// 向指定节点发送数据
scclResult_t bootstrapSend(void* commState, int peer, int tag, void* data, int size);
// 从指定节点接收数据
scclResult_t bootstrapRecv(void* commState, int peer, int tag, void* data, int size);

////////////////////
scclResult_t bootstrapInit(struct scclUniqueId* unique_id, struct scclBootstrapComm* comm);

// scclResult_t bootstrapInit(struct scclBootstrapHandle* handle, struct scclBootstrapComm* comm);
// scclResult_t
// bootstrapSplit(struct scclBootstrapHandle* handle, struct scclBootstrapComm* comm, struct scclBootstrapComm* parent, int color, int key, int* parentRanks);

} // namespace bootstrap
} // namespace topology
} // namespace hardware
} // namespace sccl
