#pragma once

#include <stdint.h>
#include "base.h"
#include "topo.h"

namespace sccl {
namespace hardware {

// 定义结构体 scclUniqueInfo，用于存储每个通信节点的信息
struct scclUniqueInfo {
    int rank;       // 当前节点的全局排名
    int nRanks;     // 总的节点数量
    int localRank;  // 当前节点在本地计算节点中的排名
    int localRanks; // 本地计算节点中的节点总数

    int cudaDev;       // CUDA 设备 ID
    int gdrSupport;    // 是否支持 GPU 直接注册 (GDR)
    uint64_t hostHash; // 主机哈希值
    uint64_t pidHash;  // 进程 ID 哈希值
    int64_t busId;     // 总线 ID
};

// // 定义结构体 scclCommBase，用于存储通信基础信息
// struct scclCommBase {
//     struct scclUniqueInfo* peerInfo;           // 指向 peerInfo 结构体的指针，存储所有节点的信息
//     sccl::hardware::net::scclNet_t* scclNet; // 指向网络结构体的指针，用于网络通信
// };

} // namespace hardware
} // namespace sccl
