#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include "mpi.h"
#include "net.h"
#include "bootstrap_net.h"

using namespace sccl;

int main(int argc, char* argv[]) {
    int rank, nranks;
    int tag1, src, dst, cnt;

    MPI_Status status;

    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &nranks);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    printf("rank=%d, nranks=%d\n", rank, nranks);

    // ----------------------------------------------------------------------- //

    INFO(SCCL_LOG_TOPO, "Bootstrap ...\n");

    (void)sccl::hardware::topology::bootstrap::bootstrap_net::bootstrapNetInit();

    MPI_Finalize();
}

/*
单机执行
SCCL_DEBUG_LEVEL=SCCL_LOG_ABORT mpirun --allow-run-as-root -np 2 1_mpi_init
SCCL_DEBUG_LEVEL=SCCL_LOG_INFO SCCL_DEBUG_POS=SCCL_LOG_CODEALL mpirun --allow-run-as-root -np 2 1_mpi_init

跨机执行
SCCL_DEBUG_LEVEL=SCCL_LOG_ABORT mpirun --allow-run-as-root --hostfile hostfile -np 16 ./1_mpi_init
*/
