#include <iostream>
#include <string>
#include <cstring>
#include <unistd.h>
#include <arpa/inet.h>
#include <ifaddrs.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <sys/socket.h>

void start_server() {
    int server_fd, new_socket;
    struct sockaddr_in address;
    int addrlen         = sizeof(address);
    char buffer[1024]   = {0};
    std::string message = "消息已收到";

    // 创建 socket 文件描述符
    if((server_fd = socket(AF_INET, SOCK_STREAM, 0)) == 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    // 绑定地址和端口
    address.sin_family      = AF_INET;
    address.sin_addr.s_addr = INADDR_ANY; // 自动获取所有 IP 地址
    address.sin_port        = htons(6842);

    if(bind(server_fd, (struct sockaddr*)&address, sizeof(address)) < 0) {
        perror("bind failed");
        close(server_fd);
        exit(EXIT_FAILURE);
    }

    // 获取绑定的端口号
    socklen_t len = sizeof(address);
    if(getsockname(server_fd, (struct sockaddr*)&address, &len) == -1) {
        perror("getsockname failed");
        close(server_fd);
        exit(EXIT_FAILURE);
    }

    int port = ntohs(address.sin_port);
    std::cout << "服务器已启动，端口: " << port << std::endl;

    // 监听连接
    if(listen(server_fd, 3) < 0) {
        perror("listen");
        close(server_fd);
        exit(EXIT_FAILURE);
    }

    std::cout << "等待连接..." << std::endl;

    // 接受客户端连接
    if((new_socket = accept(server_fd, (struct sockaddr*)&address, (socklen_t*)&addrlen)) < 0) {
        perror("accept");
        close(server_fd);
        exit(EXIT_FAILURE);
    }

    while(true) {
        // 接收数据
        int valread = read(new_socket, buffer, 1024);
        if(valread == 0) {
            break;
        }
        std::cout << "收到的消息: " << buffer << std::endl;
        send(new_socket, message.c_str(), message.length(), 0);
        memset(buffer, 0, sizeof(buffer));
    }

    // 关闭连接
    close(new_socket);
    close(server_fd);
}

int main() {
    start_server();
    return 0;
}