#include <iostream>
#include <string>
#include <cstring>
#include <unistd.h>
#include <arpa/inet.h>

void start_client(const std::string& server_ip, int server_port) {
    int sock = 0;
    struct sockaddr_in serv_addr;
    char buffer[1024]   = {0};
    std::string message = "你好，服务器！";

    // 创建 socket 文件描述符
    if((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        std::cerr << "Socket creation error" << std::endl;
        exit(EXIT_FAILURE);
    }

    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port   = htons(server_port);

    // 转换 IPv4 和 IPv6 地址
    if(inet_pton(AF_INET, server_ip.c_str(), &serv_addr.sin_addr) <= 0) {
        std::cerr << "Invalid address/ Address not supported" << std::endl;
        close(sock);
        exit(EXIT_FAILURE);
    }

    // 连接到服务器
    if(connect(sock, (struct sockaddr*)&serv_addr, sizeof(serv_addr)) < 0) {
        std::cerr << "Connection Failed" << std::endl;
        close(sock);
        exit(EXIT_FAILURE);
    }

    // 发送数据
    send(sock, message.c_str(), message.length(), 0);
    std::cout << "消息已发送" << std::endl;

    // 接收响应
    int valread = read(sock, buffer, 1024);
    std::cout << "收到的响应: " << buffer << std::endl;

    // 关闭连接
    close(sock);
}

int main() {
    std::string server_ip = "10.16.1.37";
    int server_port       = 6842;

    start_client(server_ip, server_port);
    return 0;
}