#pragma once

#include <string.h>
#include "base.h"
#include "socket.h"
#include "bootstrap_utils.h"
#include "ipc_socket.h"

namespace sccl {
namespace hardware {
namespace topology {
namespace bootstrap {

typedef class sccl::hardware::net::ipc_socket::scclIpcSocket scclIpcSocket_t;

class bootstrapNet {
public:
    // 构造函数
    bootstrapNet(struct scclBootstrapComm* bootstrap_comm);
    virtual ~bootstrapNet();

    // 初始化
    scclResult_t bootstrapNetInit();
    // 通过socket发送数据
    scclResult_t bootstrapNetSend(scclSocket_t* sock, void* data, int size);
    // 通过socket接收数据
    scclResult_t bootstrapNetRecv(scclSocket_t* sock, void* data, int size);

public:
    /* Init functions */
    char bootstrapNetIfName[MAX_IF_NAME_SIZE + 1];
    scclSocketAddress_t bootstrapNetIfAddr;

private:
    int bootstrapNetInitDone         = 0;
    pthread_mutex_t bootstrapNetLock = PTHREAD_MUTEX_INITIALIZER;

    // 用于节点内socket通信
    scclIpcSocket_t* ipcsocket = nullptr;
};

} // namespace bootstrap
} // namespace topology
} // namespace hardware
} // namespace sccl
