#pragma once

#include <string.h>
#include "base.h"
#include "socket.h"
#include "bootstrap_utils.h"
#include "bootstrap_net.h"
#include "thread_pool.h"

namespace sccl {
namespace hardware {
namespace topology {
namespace bootstrap {

class scclBootstrap {
public:
    scclBootstrap(struct scclRankInfo* rank_info, struct scclBootstrapComm* comm);
    ~scclBootstrap();

    // 初始化bootstrap通信环境
    scclResult_t bootstrapInit(const struct scclRankInfo* rank_info, struct scclBootstrapComm* comm);
    // 检查bootstrap是否已成功初始化
    scclResult_t bootstrapInitCheck();

    // 广播节点信息
    scclResult_t bootstrapAllGather(struct scclUniqueInfo* unique_info);

private:
    // 执行基本的引导程序初始化
    scclResult_t bootstrapBasicInit();
    // 初始化唯一ID信息结构体
    scclResult_t bootstrapUniqueInfoInit(const struct scclRankInfo* rank_info, scclNet_t* scclNet, struct scclUniqueInfo* unique_info);

    // scclResult_t bootstrapGetAllNodes(const struct scclUniqueInfo* unique_info, struct scclBootstrapComm* comm);

private:
    pthread_mutex_t initLock = PTHREAD_MUTEX_INITIALIZER;
    bool initialized         = false;
    bool hsaFineGrainFlag    = true;

    // 分配并初始化引导句柄
    struct scclBootstrapHandle* handle = nullptr;
    // 分配并初始化网络结构体
    class bootstrapNet* bootstrap_net = nullptr;

    int max_pthreads               = 0;
    class ThreadPool* pthread_pool = nullptr;
};

} // namespace bootstrap
} // namespace topology
} // namespace hardware
} // namespace sccl
