#pragma once

#include <pthread.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdint.h>
#include <algorithm> // For std::min/std::max
#include "sccl.h"

#ifdef PROFAPI
#define SCCL_API(ret, func, args...)                                                        \
    __attribute__((visibility("default"))) __attribute__((alias(#func))) ret p##func(args); \
    extern "C" __attribute__((visibility("default"))) __attribute__((weak)) ret func(args)
#else
#define SCCL_API(ret, func, args...) extern "C" __attribute__((visibility("default"))) ret func(args)
#endif // end PROFAPI

static __inline__ int scclTypeSize(scclDataType_t type) {
    switch(type) {
        case scclInt8:
        case scclUint8: return 1;
        case scclFloat16:
#if defined(RCCL_BFLOAT16)
        case scclBfloat16:
#endif
            return 2;
        case scclInt32:
        case scclUint32:
        case scclFloat32: return 4;
        case scclInt64:
        case scclUint64:
        case scclFloat64: return 8;
        default: return -1;
    }
}
