#pragma once

#include <rocm_smi/rocm_smi.h>
#ifdef USE_ROCM_SMI64CONFIG
#include <rocm_smi/rocm_smi64Config.h>
#endif
#include "base.h"

namespace sccl {
namespace hardware {
namespace topology {
namespace bootstrap {

// 初始化ROCm SMI库
scclResult_t rocm_smi_init();

// 获取设备数量
scclResult_t rocm_smi_getNumDevice(uint32_t* num_devs);

// 根据设备索引获取设备的PCI总线ID字符串
scclResult_t rocm_smi_getDevicePciBusIdString(uint32_t deviceIndex, char* pciBusId, size_t len);

// 根据PCI总线ID字符串获取设备索引
scclResult_t rocm_smi_getDeviceIndexByPciBusId(const char* pciBusId, uint32_t* deviceIndex);

// 获取两个设备之间的链接信息，包括链接类型、跳数和链接数量
scclResult_t rocm_smi_getLinkInfo(int srcDev, int dstDev, RSMI_IO_LINK_TYPE* rsmi_type, int* hops, int* count);

} // namespace bootstrap
} // namespace topology
} // namespace hardware
} // namespace sccl
