#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

#include "base.h"
#include "alloc.h"
#include "topo.h"
#include "xml.h"
#include "mpi.h"
#include "net.h"
#include "comm.h"
#include "graph.h"

using namespace sccl;

int main(int argc, char** argv) {

    // struct sccl::hardware::topology::topo::scclXml* xml;
    // SCCLCHECK(sccl::scclCalloc(&xml, 1));
    // std::string xmlPath = "/opt/dtk/rccl/lib/built-in-BW-topo-input.xml";
    // SCCLCHECK(scclTopoGetXmlFromFile(xmlPath.c_str(), xml, 1));

    // struct sccl::hardware::topology::topo::scclTopoSystem* topoSystem;
    // SCCLCHECK(sccl::hardware::topology::topo::scclTopoGetSystemFromXml(xml, &topoSystem));
    // printf("topoSystem net.gdrSupport:%d\n", topoSystem->nodes[0].nodes[0].net.gdrSupport);

    int rank, nranks;
    MPI_Status status;
    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &nranks);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    struct sccl::hardware::scclComm* comm;
    struct sccl::hardware::topology::topo::scclTopoSystem* topoSystem;
    SCCLCHECK(sccl::hardware::topology::topo::scclTopoGetSystem(&topoSystem));
    printf("topoSystem net.gdrSupport:%d\n", topoSystem->nodes[0].nodes[0].net.gdrSupport);
    topoSystem->nRanks             = nranks;
    topoSystem->netGdrLevel        = -2;
    topoSystem->pivotA2AEnabled    = false;
    topoSystem->pivotA2ANumBiRings = 0;
    topoSystem->ll128Enabled       = false;
    topoSystem->mscclEnabled       = false;
    topoSystem->treeDefined        = false;
    SCCLCHECK(sccl::hardware::topology::scclTopoComputePaths(topoSystem, comm));

    return 0;
}