#include <infiniband/verbs.h>

void check_network_connections() {
    struct ibv_device** dev_list;
    struct ibv_context* context;
    struct ibv_port_attr port_attr;
    int num_devices, i, port_num;

    // 获取设备列表
    dev_list = ibv_get_device_list(&num_devices);
    if(!dev_list) {
        fprintf(stderr, "Failed to get IB device list\n");
        return;
    }

    // 遍历设备列表
    for(i = 0; i < num_devices; i++) {
        context = ibv_open_device(dev_list[i]);
        if(!context) {
            fprintf(stderr, "Failed to open device %s\n", ibv_get_device_name(dev_list[i]));
            continue;
        }

        // 假设我们只检查端口 1
        port_num = 1;
        if(ibv_query_port(context, port_num, &port_attr)) {
            fprintf(stderr, "Failed to query port %d attributes on device %s\n", port_num, ibv_get_device_name(dev_list[i]));
            ibv_close_device(context);
            continue;
        }

        // 检查端口状态和连接状态
        if(port_attr.state == IBV_PORT_ACTIVE && port_attr.phys_state == 5) { // 5 表示端口已连接
            printf("Device %s, Port %d is connected.\n", ibv_get_device_name(dev_list[i]), port_num);
        } else {
            printf("Device %s, Port %d is not connected.\n", ibv_get_device_name(dev_list[i]), port_num);
        }

        ibv_close_device(context);
    }

    ibv_free_device_list(dev_list);
}

int main(int argc, char* argv[]) {
    // 获取设备列表
    check_network_connections();
    return 0;
}
