#include <iostream>
#include <vector>
#include <queue>
#include <pthread.h>
#include <functional>
#include <future>
#include <memory>

class ThreadPool {
public:
    ThreadPool(size_t);
    ~ThreadPool();

    template <class F, class... Args>
    auto enqueue(F&& f, Args&&... args) -> std::future<typename std::result_of<F(Args...)>::type> {
        using return_type = typename std::result_of<F(Args...)>::type;

        auto task = std::make_shared<std::packaged_task<return_type()>>(std::bind(std::forward<F>(f), std::forward<Args>(args)...));

        std::future<return_type> res = task->get_future();
        {
            pthread_mutex_lock(&queue_mutex);
            tasks.push([task]() { (*task)(); });
            pthread_mutex_unlock(&queue_mutex);
            pthread_cond_signal(&condition);
        }
        return res;
    }

private:
    std::vector<pthread_t> workers;
    std::queue<std::function<void()>> tasks;

    pthread_mutex_t queue_mutex;
    pthread_cond_t condition;
    bool stop;

    static void* run(void* arg);
};
