#include <iostream>
#include <vector>
#include <queue>
#include <pthread.h>
#include <functional>
#include <future>
#include <memory>
#include <thread> // 为了使用 std::this_thread::sleep_for

#include "thread_pool.h"

// 模拟一个需要时间的操作
int simulate_long_task(int id, int duration) {
    std::cout << "Task " << id << " is running..." << std::endl;
    std::this_thread::sleep_for(std::chrono::seconds(duration));
    std::cout << "Task " << id << " completed." << std::endl;
    return id + 10;
}

int main() {
    ThreadPool pool(4);

    std::future<int> task_res[10];
    // 添加多个任务到线程池
    for(int i = 0; i < 10; ++i) {
        task_res[i] = pool.enqueue(simulate_long_task, i, std::rand() % 3 + 1);
    }

    for(int i = 0; i < 10; ++i) {
        std::cout << "final " << i << " get:" << task_res[i].get() << "." << std::endl;
    }

    // 等待所有任务完成
    std::this_thread::sleep_for(std::chrono::seconds(10));

    return 0;
}