#include "archinfo.h"
#include "check.h"
#include <hip/hip_runtime.h>
#include <hip/hip_runtime_api.h>

namespace sccl {

void GcnArchNameFormat(char* gcnArchName, char* out) {
    // this function parses the char array from the device properties into something easier to handle.
    // as the gcnArchName attribute looks something like: "gfx900:xnack+:blah-:etc-"
    char* gcnArchNameToken = strtok(gcnArchName, ":");
    strcpy(out, gcnArchNameToken);
    return;
}

void convertGcnArchToGcnArchName(const char* gcnArch, const char** gcnArchName) {
    if(strcmp(gcnArch, "906") == 0)
        *gcnArchName = "gfx906";
    else if(strcmp(gcnArch, "908") == 0)
        *gcnArchName = "gfx908";
    else if(strcmp(gcnArch, "910") == 0)
        *gcnArchName = "gfx90a";
    else if(strcmp(gcnArch, "940") == 0)
        *gcnArchName = "gfx940";
    else if(strcmp(gcnArch, "941") == 0)
        *gcnArchName = "gfx941";
    else if(strcmp(gcnArch, "942") == 0)
        *gcnArchName = "gfx942";
    else
        *gcnArchName = gcnArch;
    return;
}

int GetGcnArchName(int deviceId, char* out) {
    hipDeviceProp_t devProp;
    HIPCHECK(hipGetDeviceProperties(&devProp, deviceId));
    GcnArchNameFormat(devProp.gcnArchName, out);
    return 0;
}

double GetDeviceWallClockRateInKhz(int deviceId) {
    char gcn[256];
    GetGcnArchName(deviceId, gcn);
    if(strncmp("gfx94", gcn, 5) == 0)
        return 1.0E5;
    else
        return 2.5E4;
}

bool IsArchMatch(char const* arch, char const* target) { return (strncmp(arch, target, strlen(target)) == 0); }

} // namespace sccl
