#pragma once

#include <map>
#include <string>
#include <cstddef>
#include "base.h"
#include "net.h"
#include "hardware_utils.h"

namespace sccl {
namespace hardware {
namespace topology {

constexpr int SCCL_TOPO_NODE_TYPES        = 6; // 硬件node的类型数量
constexpr int SCCL_TOPO_MAX_NODE_PER_TYPE = 4; // 每个硬件node类型中节点的数量，间接表明网络拓扑结构的最大层数
constexpr int SCCL_TOPO_RANK_MAX_LINKS    = 8; // 每个rank中节点与当前rank中其他节点的链接数量

typedef enum : int {
    CPU = 1, // 实际是numa域
    PCI = 2,
    GPU = 3,
    NVS = 4, // 包括XGMI和NVLink
    NIC = 5,
    NET = 6 // 主要是RDMA网卡
} nodeType_t;

////////////////////////////////////////////////////////////////////////////////////////////////

// // 定义拓扑节点的结构体
// struct scclTopoNode;

// // 定义拓扑链接的结构体
// struct scclTopoLink {
//     int type;                     // 链接类型
//     float bw;                     // 带宽
//     struct scclTopoNode* remNode; // 远程节点指针
// };
// // 用于表示一组拓扑节点
// struct scclTopoNodeSet {
//     int count;                                              // 节点数量
//     struct scclTopoNode nodes[SCCL_TOPO_MAX_NODE_PER_TYPE]; //
// };
// // struct scclTopoNodeSet nodes[SCCL_TOPO_NODE_TYPES];

//     //// 计算直接相连的nodes信息
//     int nlinks;                                          // 链接数量
//     struct scclTopoLink links[SCCL_TOPO_RANK_MAX_LINKS]; // rank内部直接相连的其他node的链接列表

////////////////////////////////////////////////////////////////////////////////////////////////
scclResult_t scclTopoGetStrFromSys(const char* path, const char* fileName, char* strValue);

// 将64位整数转换为总线ID字符串
scclResult_t int64ToBusId(int64_t id, char* busId);

// 将总线ID字符串转换为64位整数
scclResult_t busIdToInt64(const char* busId, int64_t* id);

scclResult_t getPciPath(const char* busId, char** path);

// 将PCI路径转换为64位整数，路径偏移量和最小偏移量作为参数
scclResult_t pciPathToInt64(char* path, int offset, int minOffset, int64_t* id);

} // namespace topology
} // namespace hardware
} // namespace sccl
