#pragma once

#include <vector>
#include "base.h"
#include "graph_utils.h"

namespace sccl {
namespace hardware {
namespace topology {
namespace graph {

class Graph {
public:
    Graph(int rank, int nRanks);
    virtual ~Graph();

    // 通信路径计算
    scclResult_t calculateCommunicationPaths(const BootstrapComm_t* bootstrap_comm, scclTopoGraph_t* topo_graph, Bootstrap* sccl_bootstrap);

    // 逻辑拓扑构建
    scclResult_t buildLogicalTopology();

    // 根据无向图计算topo路径
    scclResult_t calculateTopoChannels();

private:
    std::vector<std::vector<int>> adjacencyMatrix; // 使用邻接矩阵表示图
    // 你可以根据需要添加更多的私有成员变量和函数

    int rank, nRanks;
};

} // namespace graph
} // namespace topology
} // namespace hardware
} // namespace sccl
