#include <iostream>
#include "base.h"
#include "graph.h"
#include "paths.h"

namespace sccl {
namespace hardware {
namespace topology {
namespace graph {

Graph::Graph(int rank, int nRanks) : rank(rank), nRanks(nRanks) {
    // 构造函数的实现
}

Graph::~Graph() {
    // 析构函数的实现
}

scclResult_t Graph::calculateCommunicationPaths(const BootstrapComm_t* bootstrap_comm, scclTopoGraph_t* topo_graph, Bootstrap* sccl_bootstrap) {
    // 通信路径计算的实现
    std::cout << "Calculating communication paths..." << std::endl;

    // 调用pathFinder类，实现硬件路径搜索
    auto path_finder = PathFinder(bootstrap_comm);
    printf("calculateCommunicationPaths pos 1\n");
    // 将搜索结果写入topo_graph中，并记录有效node
    SCCLCHECK(path_finder.computeTopoGpuP2pMap(topo_graph));
    printf("calculateCommunicationPaths pos 2\n");

    // 调用bootstrap类，将transport_map进行allgather统计
    uint8_t* local_transport_map = topo_graph->getTransportMapRowStart(rank);
    SCCLCHECK(sccl_bootstrap->bootstrapAllGather(local_transport_map, topo_graph->transport_map.data(), nRanks * sizeof(uint8_t)));
    printf("calculateCommunicationPaths pos 3\n");

    // 打印transport_map
    if(bootstrap_comm->rank == 0) {
        SCCLCHECK(topo_graph->printTransportMap());
    }

    return scclSuccess;
}

scclResult_t Graph::buildLogicalTopology() {
    // 逻辑拓扑构建的实现
    std::cout << "Building logical topology..." << std::endl;
    // 具体的实现细节
    return scclSuccess;
}

scclResult_t Graph::calculateTopoChannels() {
    // 根据无向图计算topo路径的实现
    std::cout << "Calculating topo paths based on undirected graph..." << std::endl;
    // 具体的实现细节
    return scclSuccess;
}

} // namespace graph
} // namespace topology
} // namespace hardware
} // namespace sccl
