#include <stdint.h>
#include <hip/hip_runtime.h>
#include <hip/hip_runtime_api.h>

#include "base.h"
#include "hardware_utils.h"
#include "bootstrap.h"
#include "graph.h"
#include "hardware.h"

namespace sccl {
namespace hardware {

// 全局变量，全部节点的信息
typedef sccl::hardware::topology::bootstrap::BootstrapComm_t BootstrapComm_t;
typedef sccl::hardware::topology::graph::scclTopoGraph_t scclTopoGraph_t;

BootstrapComm_t* bootstrap_comm;
scclTopoGraph_t* topo_graph;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
scclResult_t scclGetUniqueId(scclUniqueId* unique_id) {
    auto handle = reinterpret_cast<BootstrapHandle_t*>(unique_id);
    NEQCHECK(sizeof(BootstrapHandle_t), SCCL_UNIQUE_ID_BYTES);
    SCCLCHECK(topology::bootstrap::bootstrapGetUniqueId(handle));
    return scclSuccess;
}

scclResult_t sccl_init(const scclUniqueId* unique_id, int rank, int nRanks) {
    // -------------------------- 1.获取0号rank的地址信息 ----------------------------------- //
    auto root_handle = reinterpret_cast<const BootstrapHandle_t*>(unique_id);
    EQCHECK(root_handle->magic, 0); // 检查handle是否已经更新

    // -------------------------- 2.初始化获取所有节点的node信息 ----------------------------------- //
    auto sccl_bootstrap = std::make_unique<topology::bootstrap::Bootstrap>(root_handle, rank, nRanks);

    bootstrap_comm = new BootstrapComm_t();
    SCCLCHECK(sccl_bootstrap->init(bootstrap_comm));
    printf("init pos 1\n");

    // -------------------------- 3.MPI 建图 ----------------------------------- //
    topo_graph      = new scclTopoGraph_t(nRanks);
    auto sccl_graph = std::make_unique<topology::graph::Graph>(rank, nRanks);
    printf("init pos 2\n");

    // 计算通信路径
    SCCLCHECK(sccl_graph->calculateCommunicationPaths(bootstrap_comm, topo_graph, sccl_bootstrap.get()));
    printf("init pos 3\n");

    // -------------------------- 3.MPI allgather设置unique_id的整合 ----------------------------------- //

    // -------------------------- 5.根据各个节点的基础信息计算topo结果 ----------------------------------- //

    // // 后续放入到sccl_finalize中
    // delete bootstrap_comm;
    // delete topo_graph;

    return scclSuccess;
}

scclResult_t sccl_finalize() {
    // 设置一些全局变量的重置和销毁
    // 设置socket等硬件监听的关闭
    // void BootstrapComm::destroy() {
    // if(bootstrap_comm.nRanks > 0) {
    //     bootstrap_comm.destroy();
    // }

    return scclSuccess;
}

} // namespace hardware
} // namespace sccl
