#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#define SOCKET_PATH "/tmp/unix_domain_socket"

void err_quit(const char* msg) {
    perror(msg);
    exit(1);
}

int main() {
    int sockfd, send_fd;
    struct sockaddr_un servaddr;
    struct iovec iov;
    struct msghdr msg;
    char buf[1024];
    char ctrl_buf[CMSG_SPACE(sizeof(int))];
    struct cmsghdr* cmsg;

    // 创建Unix域数据报套接字
    if((sockfd = socket(AF_UNIX, SOCK_DGRAM, 0)) < 0)
        err_quit("socket creation failed");

    printf("sockfd=%d\n", sockfd);
    // 清空服务器地址结构
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sun_family = AF_UNIX;
    strncpy(servaddr.sun_path, SOCKET_PATH, sizeof(servaddr.sun_path) - 1);

    // 准备发送的消息
    strcpy(buf, "Hello, Server!");
    iov.iov_base       = buf;
    iov.iov_len        = strlen(buf) + 1;
    msg.msg_name       = &servaddr;
    msg.msg_namelen    = sizeof(servaddr);
    msg.msg_iov        = &iov;
    msg.msg_iovlen     = 1;
    msg.msg_control    = ctrl_buf;
    msg.msg_controllen = sizeof(ctrl_buf);

    // 添加文件描述符到辅助数据
    cmsg             = CMSG_FIRSTHDR(&msg);
    cmsg->cmsg_level = SOL_SOCKET;
    cmsg->cmsg_type  = SCM_RIGHTS;
    cmsg->cmsg_len   = CMSG_LEN(sizeof(int));
    send_fd          = dup(STDOUT_FILENO); // 示例：发送标准输出的文件描述符
    memmove(CMSG_DATA(cmsg), &send_fd, sizeof(send_fd));

    // 发送消息
    if(sendmsg(sockfd, &msg, 0) < 0) {
        if(errno == ECONNREFUSED) {
            printf("sendmsg failed: Transport endpoint is not connected. Make sure the server is running.\n");
        } else {
            err_quit("sendmsg failed");
        }
    } else {
        printf("Message sent to server.\n");
    }

    /*
    printf("111\n");
    // 接收响应
    struct sockaddr_un from;
    socklen_t fromlen = sizeof(from);
    memset(buf, 0, sizeof(buf));
    iov.iov_base    = buf;
    iov.iov_len     = sizeof(buf);
    msg.msg_name    = &from;
    msg.msg_namelen = fromlen;
    msg.msg_iov     = &iov;
    msg.msg_iovlen  = 1;
    printf("222\n");

    if(recvmsg(sockfd, &msg, 0) < 0) {
        err_quit("recvmsg failed");
    }

    printf("333\n");
    printf("Received response from server: %s\n", buf);
    */

    close(sockfd);
    return 0;
}