#pragma once

#include <stdint.h>
#include <string.h>
#include "debug.h"
#include "check.h"
#include "param.h"
#include "alloc.h"
#include "utils.h"
#include "asm_ops.h"
#include "container.h"

/*
外部环境变量设置:

src/debug.h：
*/
namespace sccl {
#define WARP_SIZE warpSize
#define MAXCHANNELS 32
#define SCCL_MAX_NTHREADS 256
#define SCCL_MAX_OPS 2048
#define SCCL_STEPS 8
#define SCCL_LOCAL_MAX_NODES 8 // 每个节点内最多的卡数

typedef enum : uint8_t {
    scclInt8     = 0,
    scclChar     = 0,
    scclUint8    = 1,
    scclInt32    = 2,
    scclInt      = 2,
    scclUint32   = 3,
    scclInt64    = 4,
    scclUint64   = 5,
    scclFloat16  = 6,
    scclHalf     = 6,
    scclFloat32  = 7,
    scclFloat    = 7,
    scclFloat64  = 8,
    scclDouble   = 8,
    scclBfloat16 = 9,
} scclDataType_t;

#define SCCL_NUM_PROTOCOLS 3 // Simple/LL/LL128
typedef enum : uint8_t {
    SCCL_PROTO_LL     = 0,
    SCCL_PROTO_LL128  = 1,
    SCCL_PROTO_SIMPLE = 2
} scclProtocolType_t;

} // namespace sccl
