#pragma once

#include <map>
#include <string>
#include <cstddef>
#include <vector>
#include "base.h"
#include "topo_utils.h"
#include "comm.h"
#include "rocm_smi_wrap.h"

namespace sccl {
namespace hardware {
namespace topology {
namespace bootstrap {

typedef union net::net_socket::scclSocketAddress scclSocketAddress_t;
typedef struct net::net_socket::scclSocket scclSocket_t;
typedef net::scclNet_t scclNet_t;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 用于初始化时广播0号rank的地址信息
typedef struct BootstrapHandle {
    uint64_t magic = 0;       // 随机码，用于socket通信
    scclSocketAddress_t addr; // 地址，用于网络通信
} BootstrapHandle_t;

#define SCCL_UNIQUE_ID_BYTES (40) // sizeof(BootstrapHandle_t)
typedef struct {
    char internal[SCCL_UNIQUE_ID_BYTES];
} scclUniqueId;

// 仅用于初始化的函数bootstrapCreateRoot，用于传递detach线程的参数
typedef struct bootstrapRootArgs {
    uint64_t magic;
    scclSocket_t* listenSock = nullptr; // 根节点的监听
} bootstrapRootArgs_t;

// 用于初始建立连接阶段，0号rank之外的进程向其传递的信息
typedef struct BootstrapNodeBasic {
    int rank;
    int nRanks;        // 进程的总数量
    uint64_t hostHash; // 用于区分host的CPU编号
    scclSocket_t sock; // 各个进程的监听套接字地址，用于网络通信
} BootstrapNodeBasic_t;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 获取主机唯一标识的哈希值，该哈希值在裸机和容器实例中都是唯一的
uint64_t getHostHash(void);

// 获取当前进程的唯一哈希标识符
uint64_t getPidHash(void);

// 从/dev/urandom设备获取随机数据填充缓冲区
scclResult_t getRandomData(void* buffer, size_t bytes);

// 获取指定CUDA设备的PCI总线ID并转换为64位整数
scclResult_t getBusId(int hipDev, int64_t* busId);

// 获取当前HIP设备的计算能力版本号
int scclCudaCompCap(void);

} // namespace bootstrap
} // namespace topology
} // namespace hardware
} // namespace sccl
