#pragma once

#include <stdint.h>
#include <memory>

#include "base.h"
#include "net_utils.h"
#include "net_socket/socket.h"
#include "net_ib/net_ib.h"
#include "net_socket/net_socket.h"

namespace sccl {
namespace hardware {
namespace net {

// 定义一个静态的pthread互斥锁，用于线程同步
static pthread_mutex_t netLock = PTHREAD_MUTEX_INITIALIZER;

//////////////////////////////////// 功能函数 ////////////////////////////////////
// 打印Socket信息
scclResult_t printSocketAddr(union net_socket::scclSocketAddress* sock_addr, const char* prefix);
scclResult_t printSocketInfo(struct net_socket::scclSocket* sock, const char* prefix);

//////////////////////////////////// 网络接口 ////////////////////////////////////
// 定义网络类型数量的常量
constexpr int scclNetTypeNum = 3;

// 定义一个内联数组，存储不同类型的sccl网络指针
inline scclNetBase* scclNets[] = {nullptr, new net_ib::scclNetIb(), new net_socket::scclNetSocket()};

// 定义初始化sccl网络的函数
scclResult_t scclNetInit(const char* netName, scclNet_t*& scclNet);

} // namespace net
} // namespace hardware
} // namespace sccl
