#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <mpi.h>

#include "bootstrap.h"
#include "hardware.h"

using namespace sccl;

int main(int argc, char* argv[]) {
    // -------------------------- 1.启动MPI ----------------------------------- //
    MPI_Init(&argc, &argv);
    int rank, nRanks;
    MPI_Comm_size(MPI_COMM_WORLD, &nRanks);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    printf("rank=%d, nRanks=%d\n", rank, nRanks);

    sccl::hardware::topology::bootstrap::BootstrapHandle_t uqid;
    sccl::hardware::topology::bootstrap::scclRankInfo_t rankinfo;
    sccl::hardware::topology::bootstrap::scclNodeInfo_t nodeinfo(/*nLocalRanks*/ 2);
    printf("rankinfo size=%lu\n", sizeof(rankinfo));
    printf("rankinfo cpu size=%lu\n", sizeof(rankinfo.cpu));
    printf("rankinfo gpu size=%lu\n", sizeof(rankinfo.gpu));
    printf("rankinfo net size=%lu\n", sizeof(rankinfo.net));
    printf("nodeinfo size=%lu, stu size=%d\n", sizeof(nodeinfo), nodeinfo.totalByteSize);
    // topoNode_t topo_node;
    // printf("topo_node size=%lu\n", sizeof(topo_node));

    // -------------------------- 2.获取节点unique_id，主要是socket地址 ----------------------------------- //
    typedef sccl::hardware::topology::bootstrap::scclUniqueId scclUniqueId;
    scclUniqueId unique_id;
    if(rank == 0) {
        SCCLCHECK(sccl::hardware::scclGetUniqueId(&unique_id));
    }
    MPI_Bcast(&unique_id, sizeof(scclUniqueId), MPI_BYTE, 0, MPI_COMM_WORLD);

    // -------------------------- 3.基于unique_id的整合结果初始化 ----------------------------------- //
    SCCLCHECK(sccl::hardware::sccl_init(&unique_id, rank, nRanks));

    // int cuda_id;
    // HIPCHECK(hipGetDevice(&cuda_id));
    // printf("rank=%d, cuda_id=%d\n", rank, cuda_id);

    // MPI_Barrier(MPI_COMM_WORLD);
    SCCLCHECK(sccl::hardware::sccl_finalize());
    MPI_Finalize();
}

/*
单机执行
SCCL_DEBUG_LEVEL=WARN mpirun --allow-run-as-root -np 4 3_mpi_init_mpi_init_step2_graph
SCCL_DEBUG_LEVEL=WARN SCCL_DEBUG_SUBSYS=ALL mpirun --allow-run-as-root -np 2 3_mpi_init_mpi_init_step2_graph

跨机执行
SCCL_DEBUG_LEVEL=WARN SCCL_DEBUG_SUBSYS=GRAPH mpirun --allow-run-as-root --hostfile hostfile2 -np 2 ./3_mpi_init_mpi_init_step2_graph
SCCL_DEBUG_LEVEL=WARN SCCL_DEBUG_SUBSYS=GRAPH mpirun --allow-run-as-root --hostfile hostfile2 -np 4 ./3_mpi_init_mpi_init_step2_graph
SCCL_DEBUG_LEVEL=WARN SCCL_DEBUG_SUBSYS=BOOTSTRAP mpirun --allow-run-as-root --hostfile hostfile -np 16 ./3_mpi_init_mpi_init_step2_graph
*/
