# pam_rs

pam_rs是一个pam认证模块，在pam系统调用该模块时，会向指定的接口发送POST请求，根据返回值确定是否放行

## 编译与安装

```shell
cargo build --release
cp target/release/libpam_rs.so /usr/lib64/security/pam_rs.so
```

## 配置

编辑 /etc/pam.d/sshd

```
#%PAM-1.0
auth       substack     password-auth
auth       include      postlogin

# 在所有auth动作的最后添加下面这一行
# 其中，url表示post请求的地址，totp为基于时间的验证码密钥
# 添加debug参数，会将调试信息打印在/tmp/pam_rs.log中
account    required     pam_rs.so url=http://127.0.0.1:99/pam/auth totp=FRZPBN2FAZMJY7G2FKTBZVXNNU #debug
account    required     pam_sepermit.so
account    required     pam_nologin.so
account    include      password-auth
account    requisite    pam_access.so
password   include      password-auth
# pam_selinux.so close should be the first session rule
session    required     pam_selinux.so close
session    required     pam_loginuid.so
# pam_selinux.so open should only be followed by sessions to be executed in the user context
session    required     pam_selinux.so open env_params
session    required     pam_namespace.so
session    optional     pam_keyinit.so force revoke
session    optional     pam_motd.so
session    include      password-auth
session    include      postlogin
```

## 接口

post请求包含请求头：

```
Authorization: Bearer <token>
```

其中，token为Base64编码的6位验证码，验证码由totp参数指定的密钥根据Google的totp算法计算得出。

请求体为：

```
{
  "host": [
    "10.16.6.11",
    "12.12.12.41",
    "13.13.2.11",
    "13.13.3.11",
    "13.13.4.11",
    "13.13.5.11",
    "13.13.6.11",
    "13.13.7.11",
    "13.13.8.11",
    "192.168.122.1",
    "172.17.0.1"
  ],
  "user": "liming6"
}
```

其中：

- user表示登录的用户
- host为一个列表，记录用户登录的服务器的网卡的IPv4地址

返回字符串0表示放行，其他值表示拒绝登录

请求有1秒的超时时间，接口不可访问或者超时将放行，由pam配置后续模块继续校验

root用户登录会直接放行

## 调试

使用 `pamtester` 工具进行调试

```
cp /etc/pam.d/sshd /etc/pam.d/abc


nano /etc/pam.d/abc
# 添加debug参数，在/tmp/pam_rs.log中查看输出
# account    required     pam_rs.so url=http://127.0.0.1:99/pam/auth totp=FRZPBN2FAZMJY7G2FKTBZVXNNU debug

# 其中，abc为应用名，liming6为用户名，acct_mgmt表示验证用户是否能登录
pamtester abc liming6 acct_mgmt
```

## 用途

pam_rs认证模块搭配管理系统即可轻松、优雅地实现访问控制、按时间段放行等功能


