package logic

import (
	"fmt"
	"strings"
)

type CardInfo struct {
	Type  uint8 // 0 dcu 1 nvidia
	Index uint8
	Pids  []int
}

func (ci *CardInfo) String() string {
	var cardType string
	switch ci.Type {
	case 0:
		cardType = "dcu"
	case 1:
		cardType = "nvidia"
	default:
		cardType = "unknow"
	}
	is := make([]string, 0, len(ci.Pids))
	for _, v := range ci.Pids {
		is = append(is, fmt.Sprintf("%d", v))
	}
	return fmt.Sprintf("%s:%d:%s", cardType, ci.Index, strings.Join(is, ","))
}
