package main

import (
	"fmt"
	"get-container/cmd/hytop/backend"
	"get-container/cmd/hytop/tui"
	"log"
	"os"

	tea "github.com/charmbracelet/bubbletea"
	"github.com/charmbracelet/x/term"
	"github.com/spf13/pflag"
)

var (
	flagHelp    = pflag.BoolP("help", "h", false, "show help info of hytop")
	flagVersion = pflag.BoolP("version", "v", false, "show version info of hytop")
)

func main() {
	pflag.Parse()
	if *flagVersion {
		fmt.Printf("hytop version: %s\n", tui.DCUTopVersion)
		os.Exit(0)
	}
	if *flagHelp {
		fmt.Println("hytop: a tool that allows viewing the operation status of DCU from the command line")
		fmt.Println("Usage of hytop:")
		fmt.Println("  hytop [option]")
		fmt.Println("options: ")
		pflag.PrintDefaults()
		os.Exit(0)
	}

	w, h, err := term.GetSize(os.Stdout.Fd())
	if err != nil {
		log.Fatalf("error get terminal size: %v", err)
	}

	err = backend.Init()
	if err != nil {
		log.Fatalf("error init data backend: %v", err)
	}
	model := tui.NewModelMain(w, h)
	err = model.Prepare()
	if err == nil {
		if _, err := tea.NewProgram(&model, tea.WithAltScreen()).Run(); err != nil {
			backend.Shutdown()
			log.Fatalf("error create program; %v", err)
		}
	} else {
		log.Println("init model error, dcu may be unhealthy")
	}
	backend.Shutdown()
	os.Exit(0)
}
