package utils

import (
	"strings"
	"testing"
)

func TestRegexp(t *testing.T) {
	t.Log(ReUnit.MatchString("b"))
	t.Log(ReUnit.MatchString("kb"))
	t.Log(ReUnit.MatchString("kib"))

	t.Logf("%+v, %d", ReUnit.FindStringSubmatch("b"), len(ReUnit.FindStringSubmatch("b")))
	t.Logf("%+v, %d", ReUnit.FindStringSubmatch("kb"), len(ReUnit.FindStringSubmatch("kb")))
	t.Logf("%+v, %d", ReUnit.FindStringSubmatch("kib"), len(ReUnit.FindStringSubmatch("kib")))

	if ReStorageSize.MatchString("123MiB") {
		t.Logf("%+v", ReStorageSize.FindStringSubmatch("123MiB"))
	} else {
		t.Errorf("Error match 123MiB")
	}

	if ReStorageSize.MatchString("123MB") {
		t.Logf("%+v", ReStorageSize.FindStringSubmatch("123MB"))
	} else {
		t.Errorf("Error match 123MB")
	}
}

func TestParseUnit(t *testing.T) {
	testData := []string{"MiB", "MB", "B", "b"}
	result := []StorageCapacityUnit{MiB, MB, Byte, Byte}
	for index, unit := range testData {
		u, err := ParseUnit(unit)
		if err != nil {
			t.Errorf("Error match %d: %s", index, err)
		}
		if u != result[index] {
			t.Errorf("Error match %d: expected %d, got %d", index, u, result[index])
		}
	}
}

func TestParseMemorySize(t *testing.T) {
	testData := []string{"1MiB", "2MB", "3B", "4b", "5 PiB"}
	result := []MemorySize{{Num: 1, Unit: MiB}, {Num: 2, Unit: MB}, {Num: 3, Unit: Byte}, {Num: 4, Unit: Byte}, {Num: 5, Unit: PiB}}
	for index, unit := range testData {
		u, err := ParseMemorySize(unit)
		if err != nil {
			t.Errorf("Error match %d: %s", index, err)
		}
		if u.Num != result[index].Num || u.Unit != result[index].Unit {
			t.Errorf("Error match %d: expected %d, got %d", index, u, result[index])
		}
	}
}

func TestHumanReadStr(t *testing.T) {
	ms := MemorySize{Num: 1025, Unit: Byte}
	t.Log(ms.HumanReadStr(2))
	ms.Num = 1025
	ms.Unit = PiB
	t.Log(ms.HumanReadStr(1))
}

func TestFo(t *testing.T) {
	sb := strings.Builder{}
	sb.WriteString("hello world\n")
	sb.WriteString("time is come\n")
	t.Log(sb.String())
	sb.WriteString("okoko")
	t.Log(sb.String())
}
