package tui

import (
	"fmt"
	"testing"

	"github.com/charmbracelet/lipgloss"
)

const S = `├───────────────────────────────┼──────────────────────┼──────────────────────┼
│ 2    BW200,            manual │ 0000:5e:00.0     Off │ Off               On │ DCU: ░░░░░░░░░░░░░░░░░░░░░░░░░   0% │`

func TestLine(t *testing.T) {
	t.Logf("%d", lipgloss.Width(S))
}

func TestHeader(t *testing.T) {
	m := ModelHeader{}
	cmd := m.Init()
	m.Update(cmd)
	fmt.Println(m.View())
}

func TestAis(t *testing.T) {
	for i := 10; i < 180; i++ {
		str := genXAxis(i)
		if lipgloss.Width(str) != i {
			t.Error("error length")
		}
		fmt.Println(str)
	}
}

func TestFormatStr(t *testing.T) {
	str := lipgloss.NewStyle().Foreground(lipgloss.Color("#2b95ffff")).SetString("hello world!").String()
	t.Logf("|%s|", FormatStr(str, 5, lipgloss.Left))
	t.Logf("|%s|", FormatStr(str, 5, lipgloss.Right))
	t.Logf("|%s|", FormatStr(str, 20, lipgloss.Left))
	t.Logf("|%s|", FormatStr(str, 20, lipgloss.Right))
}

func TestModel(t *testing.T) {
	m := NewModelMain(200, 100)
	m.Init()
	m.DCUInfo.Update(m.modelMsg)
	str := m.View()
	t.Log(str)
}
