# Readme

这是一个类似Prometheus的监控工具，目前的想法是采集服务器上使用GPU/DCU的进程信息
主要包含两部分：

- 探针：部署在每个需要被监控的服务器上，暴露服务器中使用GPU/DCU进程的相关信息
- 收集器：收集各个探针的数据，并记录下来，且支持查询

写这个工具的目的是希望能快速快速找到哪些节点的GPU/DCU是空的，没有被使用的。
nvidia-dcgm-exporter和dcu-exporter收集的是一些数字指标信息，不能直观的体现GPU/DCU是否被占用

***本工具的另一个目的是希望能追查到进程的真实用户，以便统计每个人的GPU使用率***

## 关键组件选型

数据库

- prometheus/tsdb

序列化方法

- json
- CBOR

## 如何确定谁使用了显卡、加速卡

编写本工具的一个目的是想了解是哪些Linux系统用户在使用显卡

对于曙光环境，使用显卡的方式主要有两种

- docker容器
- 主机进程使用

对于docker容器，我们认为谁创建了容器，那么该容器中的进程使用了显卡，就认为是容器的创建者使用了显卡
对于主机进程，那就是进程的用户使用了显卡

复杂情况：

- sudo转换用户执行
- su转换用户

思路或方法：

- docker
  - 使用audit审计docker命令、docker.sock文件
  - 使用空壳脚本记录
  - 代理和转发docker.sock文件
  - 使用falco审计工具
  - 监听/var/run/docker.sock
- 主机进程
  - 直接审计使用显卡设备的进程

### docker监控

audit方案
```shell
auditctl -w /usr/bin/docker -p x -k docker-cmd
auditctl -w /var/run/docker.sock -p rwxa -k docker-daemon

ausearch -k docker-daemon | aureport -f -i
```

空壳shell方案: 编写一个空壳脚本替代原本的docker命令，在执行实际docker命令前记录相关信息，以下是空壳脚本的内容
```shell
#!/bin/bash

REAL_SUFFIX='-real'
BASE_NAME=$(basename "$0")
REAL_CMD="${BASE_NAME}$REAL_SUFFIX"
LOG_FILE="/var/log/${BASE_NAME}-call.log"
[[ -f "$LOG_FILE" ]] || (touch "$LOG_FILE" && chmod 666 "$LOG_FILE")

# 记录调用信息
{
    TIMESTAMP=$(date +"%Y-%m-%d %H:%M:%S")
    echo "=== [${TIMESTAMP}] ==="
    echo "Command   : $0"
    echo "All args  : $*"
    echo "PID       : $$"
    echo "Parent PID: $PPID"
    PARENT_INFO=$(ps -fp $PPID)
    echo "Parent Info:"
    echo "$PARENT_INFO"
    echo "--- Environment ---"
    env
    echo "--- Environment ---"
    echo "----- Output -----"

} >> "$LOG_FILE"
(exec /usr/bin/"${REAL_CMD}" "$@") | tee "$LOG_FILE"
{
    echo "----- Output -----"
    echo ""
} >> "$LOG_FILE"
```

falco方案与audit的方案类似，本质上都是使用eBPF抓包，这里省略

### 针对sudo和su的方法

- 记录进程树
- 检查进程信息 /proc/\<PID\>/{status,sessionid,stat,environment}
- 使用who或last命令
- audit审计
- 使用pam会话记录
- acct记账
