package backend

import (
	"encoding/json"
	"testing"
)

func TestGetOnlineUser(t *testing.T) {
	lui, err := GetOnlineUser()
	if err != nil {
		t.Error(err)
	}
	for _, v := range lui {
		t.Logf("%+v", v)
	}
	bj, err := json.Marshal(lui)
	if err != nil {
		t.Error(err)
	}
	t.Logf("%s", string(bj))
}

func TestUpdateInfo(t *testing.T) {
	Init()
	defer Shutdown()

	err := DCUSInfoMap.UpdateInfo()
	if err != nil {
		t.Error(err)
	}
	info, lock := DCUSInfoMap.GetInfo()
	defer lock.Unlock()
	for k, v := range info {
		t.Logf("%d: %+v", k, v)
	}

}

func TestGetDCULoad(t *testing.T) {
	Init()
	defer Shutdown()
	load, err := GetDCULoad()
	if err != nil {
		t.Error(err)
	}
	for _, v := range load {
		t.Logf("%+v", v)

		b := []byte(v.Name)
		result := make([]byte, 0, len(b))
		for _, v := range b {
			if v != 0 {
				result = append(result, v)
			} else {
				break
			}
		}
		t.Logf("%s", string(result))
		t.Logf("%d", len(result))
	}
}
