package lib

import (
	"testing"
)

func TestRSMI_compute_process_info_get(t *testing.T) {
	RSMI_init()
	defer RSMI_shut_down()
	info, result := RSMI_compute_process_info_get()
	if result != nil {
		t.Error(result)
	}
	t.Logf("%+v", info)
}

func TestRSMI_dev_fan_rpms_get(t *testing.T) {
	RSMI_init()
	defer RSMI_shut_down()
	rpm, res := RSMI_dev_fan_rpms_get(0)
	t.Log(rpm, res)
}

func TestRSMI_dev_temp_metric_get(t *testing.T) {
	RSMI_init()
	defer RSMI_shut_down()

	tmp, res := RSMI_dev_temp_metric_get(0)
	t.Log(tmp, res)
}

func TestRSMI_dev_power_ave_get(t *testing.T) {
	RSMI_init()
	defer RSMI_shut_down()
	pwr, res := RSMI_dev_power_ave_get(0)
	t.Log(pwr, res)
}

func TestRSMI_dev_power_cap_get(t *testing.T) {
	RSMI_init()
	defer RSMI_shut_down()
	pwr, res := RSMI_dev_power_cap_get(0)
	t.Log(pwr, res)
}

func TestRSMI_dev_pci_id_get(t *testing.T) {
	RSMI_init()
	defer RSMI_shut_down()
	pwr, res := RSMI_dev_pci_id_get(0)
	t.Log(pwr, res)
	t.Logf("%X", pwr)
}

func TestRSMI_dev_memory_total_get(t *testing.T) {
	RSMI_init()
	defer RSMI_shut_down()
	mem, res := RSMI_dev_memory_total_get(0)
	t.Log(mem, res)
}

func TestRSMI_dev_memory_usage_get(t *testing.T) {
	RSMI_init()
	defer RSMI_shut_down()
	mem, res := RSMI_dev_memory_usage_get(0)
	t.Log(mem, res)
}

func TestRSMI_ecc_enable(t *testing.T) {
	RSMI_init()
	defer RSMI_shut_down()
	a, res := RSMI_ecc_enable(0)
	t.Log(a, res)
}

func TestRSMI_dev_brand_get(t *testing.T) {
	RSMI_init()
	defer RSMI_shut_down()
	num, res := RSMI_num_monitor_devices()
	if res != nil {
		t.Error()
	}
	for i := range num {
		name, res := RSMI_dev_subsystem_name_get(i)
		t.Log(i, name, res)
	}
}

func TestRocmlib(t *testing.T) {
	rlib := GetRocmlib()
	b, err := rlib.Init()
	if err != nil || !b {
		t.Error(err)
	}
	defer rlib.Shutdown()
	num, err := rlib.GetDevNumber()
	if err != nil {
		t.Error(err)
	}
	t.Logf("car num is : %d", num)
	name, err := rlib.GetDevName()
	if err != nil {
		t.Error(err)
	}
	t.Logf("%+v", name)

	plevel, err := rlib.GetPerfLevel()
	if err != nil {
		t.Error(err)
	}
	t.Logf("%+v", plevel)
	fan, err := rlib.GetFanSpeed()
	if err != nil {
		t.Error(err)
	}
	t.Logf("%+v", fan)

	temp, err := rlib.GetTemp()
	if err != nil {
		t.Error(err)
	}
	t.Logf("%+v", temp)

	avg, err := rlib.GetPowerAvg()
	if err != nil {
		t.Error(err)
	}
	t.Logf("%+v", avg)

	cap, err := rlib.GetPowerCap()
	if err != nil {
		t.Error(err)
	}
	t.Logf("%+v", cap)

	pci, err := rlib.GetPCIBusId()
	if err != nil {
		t.Error(err)
	}
	t.Logf("%+v", pci)

	memTotal, err := rlib.GetMemTotal()
	if err != nil {
		t.Error(err)
	}
	t.Logf("%+v", memTotal)

	memUsed, err := rlib.GetMemUsed()
	if err != nil {
		t.Error(err)
	}
	t.Logf("%+v", memUsed)

	busy, err := rlib.GetBusyPercent()
	if err != nil {
		t.Error(err)
	}
	t.Logf("%+v", busy)

	v, err := rlib.GetSystemDriverVersion()
	if err != nil {
		t.Error(err)
	}
	t.Log(v)

	infos, err := rlib.GetProcessInfo()
	if err != nil {
		t.Error(err)
	}
	t.Log(infos)

}
