package tui

import (
	"fmt"
	"get-container/cmd/hytop/backend"
	"get-container/cmd/hytop/tchart"
	"testing"
	"time"

	"github.com/charmbracelet/lipgloss"
)

const S = `├───────────────────────────────┼──────────────────────┼──────────────────────┼
│ 2    BW200,            manual │ 0000:5e:00.0     Off │ Off               On │ DCU: ░░░░░░░░░░░░░░░░░░░░░░░░░   0% │`

func TestLine(t *testing.T) {
	t.Logf("%d", lipgloss.Width(S))
}

func TestHeader(t *testing.T) {
	m := ModelHeader{}
	cmd := m.Init()
	m.Update(cmd)
	fmt.Println(m.View())
}

func TestAis(t *testing.T) {
	for i := 10; i < 180; i++ {
		str := genXAxis(i)
		if lipgloss.Width(str) != i {
			t.Error("error length")
		}
		fmt.Println(str)
	}
}

func TestFormatStr(t *testing.T) {
	str := lipgloss.NewStyle().Foreground(lipgloss.Color("#2b95ffff")).SetString("hello world!").String()
	t.Logf("|%s|", FormatStr(str, 5, lipgloss.Left))
	t.Logf("|%s|", FormatStr(str, 5, lipgloss.Right))
	t.Logf("|%s|", FormatStr(str, 20, lipgloss.Left))
	t.Logf("|%s|", FormatStr(str, 20, lipgloss.Right))
}

func TestModel(t *testing.T) {
	m := NewModelMain(200, 100)
	m.Init()
	m.DCUInfo.Update(m.modelMsg)
	str := m.View()
	t.Log(str)
}

func TestMyTimeChart(t *testing.T) {
	chart := NewTimeChart(100, 5, 0.0, 100.0, map[string]lipgloss.Color{"default": lipgloss.Color("#ff2222ff"), "other": lipgloss.Color("#0037ffff")})
	chart.Init()
	s := chart.View()
	t.Logf("\n%s", s)
	time.Sleep(time.Second)
	now := time.Now()
	points := make(map[string][]tchart.TimePoint)
	points["default"] = []tchart.TimePoint{{Time: now, Value: 94.0}}
	points["other"] = []tchart.TimePoint{{Time: now, Value: 94.0}}
	chart.Update(MyTimeChartMsg{Points: points})
	time.Sleep(time.Second)
	now = time.Now()
	points = make(map[string][]tchart.TimePoint)
	points["default"] = []tchart.TimePoint{{Time: now, Value: 0.0}}
	points["other"] = []tchart.TimePoint{{Time: now, Value: 0.0}}
	chart.Update(MyTimeChartMsg{Points: points})
	t.Logf("\n%s", chart.View())
	t.Logf("ok")
}

func TestBinaryHeap(t *testing.T) {
	err := backend.Init()
	if err != nil {
		t.Error(err)
	}
	defer backend.Shutdown()
	main := NewModelMain(200, 60)
	c := main.Init()
	main.Update(c)
	main.View()
}

func TestSysloadInit(t *testing.T) {

	start := time.Now()
	sys := NewModelSysLoad(200)
	d := time.Since(start)
	t.Logf("%d ms", d.Milliseconds())
	start = time.Now()
	ts := sys.init()
	d = time.Since(start)
	t.Logf("%d ms", d.Milliseconds())
	for _, tt := range ts[1:] {
		t.Logf("%d ms", tt.Sub(ts[0]).Milliseconds())
	}
}
