package utils

import (
	"testing"
	"time"

	"github.com/shirou/gopsutil/v4/cpu"
	"github.com/shirou/gopsutil/v4/process"
)

func TestGetSysUsers(t *testing.T) {
	a, e := cpu.Percent(0, false)
	if e != nil {
		t.Error(e)
	}
	t.Logf("%+v", a)
}

func TestGetSysInfo(t *testing.T) {
	start := time.Now()
	info, err := GetSysInfo()
	d := time.Since(start)
	if err != nil {
		t.Error(err)
	}
	t.Logf("%d: %+v", d.Microseconds(), *info)
}

func BenchmarkGetSysInfo(b *testing.B) {
	result := make([]float64, b.N)
	for i := 0; i < b.N; i++ {
		info, err := GetSysInfo()
		if err != nil {
			b.Error(err)
		}
		result[i] = info.CPUPercent
	}
	b.Logf("%+v", result)
}

func TestCPUTime(t *testing.T) {
	p, _ := process.NewProcess(1)
	tt, _ := p.Times()
	t.Logf("%s", tt.String())
	tt1 := time.Duration(int((tt.User + tt.System))) * time.Second
	t.Logf("%s", tt1.String())
}
