package main

import (
	"get-container/cmd/hytop/backend"
	"get-container/cmd/hytop/tui"
	"log"
	"os"

	tea "github.com/charmbracelet/bubbletea"
	"github.com/charmbracelet/x/term"
)

func main() {
	w, h, err := term.GetSize(os.Stdout.Fd())
	if err != nil {
		log.Fatalf("error get terminal size: %v", err)
	}

	err = backend.Init()
	if err != nil {
		log.Fatalf("error init data backend: %v", err)
	}
	model := tui.NewModelMain(w, h)
	if _, err := tea.NewProgram(&model).Run(); err != nil {
		log.Fatalf("error create program; %v", err)
	}
	backend.Shutdown()
	os.Exit(0)
}
