package gpu

import (
	"encoding/json"
	"strings"
	"testing"
)

func TestGetHYVersionInfo(t *testing.T) {
	ver, err := GetHYVersionInfo()
	if err != nil {
		t.Errorf("error get hygon dcu version info: %v", err)
	}
	t.Logf("version: %+v", ver)
}

func TestGetSMIAllOutput(t *testing.T) {
	info, err := GetSMIAllOutput()
	if err != nil {
		t.Errorf("error get hygon dcu device info: %v", err)
	}
	for _, i := range info {
		t.Logf("%+v", i)
	}
}

func TestGetRunningInfo(t *testing.T) {
	info, err := GetRunningInfo()
	if err != nil {
		t.Errorf("error get hygon dcu running info: %v", err)
	}
	for _, i := range info {
		t.Logf("%+v", i)
	}
}

func TestGetDCUPidInfo(t *testing.T) {
	info, err := GetDCUPidInfo()
	if err != nil {
		t.Errorf("error get hygon dcu process: %v", err)
	}
	for _, i := range info {
		t.Logf("%+v", i)
	}
}

func TestJson(t *testing.T) {
	str := "['0','2']"
	s := make([]string, 0)
	err := json.Unmarshal([]byte(strings.ReplaceAll(str, "'", `"`)), &s)
	if err != nil {
		t.Errorf("error unmarshal: %v", err)
	}
	t.Logf("%+v", s)
}
