package tui

import (
	"fmt"
	"time"

	tea "github.com/charmbracelet/bubbletea"
	"github.com/charmbracelet/lipgloss"
)

type ModelHeader struct {
	t             time.Time
	DCUTopVersion string
	SMIVersion    string
	DriverVersion string
}

func (mh *ModelHeader) Init() tea.Cmd {
	mh.t = time.Now()
	return nil
}

func (mh *ModelHeader) Update(inputMsg tea.Msg) (tea.Model, tea.Cmd) {
	switch msg := inputMsg.(type) {
	case ModelMsg:
		mh.t = msg.t
		mh.DCUTopVersion = msg.MyVersion
		mh.DriverVersion = msg.Version.DriverVersion
		mh.SMIVersion = msg.Version.SMIVersion
		return mh, nil
	case *ModelMsg:
		mh.t = msg.t
		mh.DCUTopVersion = msg.MyVersion
		mh.DriverVersion = msg.Version.DriverVersion
		mh.SMIVersion = msg.Version.SMIVersion
		return mh, nil
	}
	return mh, nil
}

func (mh *ModelHeader) View() string {
	header := fmt.Sprintf("%s                  (Press h for help or q for quit)\n", mh.t.Format("2006-01-02 15:04:05"))
	style := lipgloss.NewStyle().Padding(0, 1)
	borderStyle := lipgloss.NewStyle().Border(myBorder, true, true, false, true)
	hyv := style.Width(18).Render(fmt.Sprintf("hytop: %s", mh.DCUTopVersion))
	drv := style.Width(35).Render(fmt.Sprintf("Driver Version: %s", mh.DriverVersion))
	smiv := style.Width(24).Render(fmt.Sprintf("SMI Version: %s", mh.SMIVersion))

	return header + borderStyle.Render(hyv+drv+smiv) +
		`
├───────────────────────────────┬──────────────────────┬──────────────────────┤
│ GPU  Name        Persistence-M│ Bus-Id        Disp.A │ MIG M.   Uncorr. ECC │
│ Fan  Temp  Perf  Pwr:Usage/Cap│         Memory-Usage │ GPU-Util  Compute M. │
`
}
