package utils

import (
	"slices"
	"strings"
)

type CharType byte

const (
	MW = `
⠀⠀|⠁⡇|⠂⡆|⠃⡇|⠄⡄|⠅⡇|⠆⡆|⠇⡇|⠈⢸|⠉⣿|⠊⣾|⠋⣿|⠌⣼|⠍⣿|⠎⣾|⠏⣿
⠐⢰|⠑⣷|⠒⣶|⠓⣷|⠔⣴|⠕⣷|⠖⣶|⠗⣷|⠘⢸|⠙⣿|⠚⣾|⠛⣿|⠜⣼|⠝⣿|⠞⣾|⠟⣿
⠠⢠|⠡⣧|⠢⣦|⠣⣧|⠤⣤|⠥⣧|⠦⣦|⠧⣧|⠨⢸|⠩⣿|⠪⣾|⠫⣿|⠬⣼|⠭⣿|⠮⣾|⠯⣿
⠰⢰|⠱⣷|⠲⣶|⠳⣷|⠴⣴|⠵⣷|⠶⣶|⠷⣷|⠸⢸|⠹⣿|⠺⣾|⠻⣿|⠼⣼|⠽⣿|⠾⣾|⠿⣿
⡀⡀|⡁⡇|⡂⡆|⡃⡇|⡄⡄|⡅⡇|⡆⡆|⡇⡇|⡈⣸|⡉⣿|⡊⣾|⡋⣿|⡌⣾|⡍⣿|⡎⣾|⡏⣿
⡐⣰|⡑⣷|⡒⣶|⡓⣷|⡔⣴|⡕⣷|⡖⣶|⡗⣷|⡘⣸|⡙⣿|⡚⣾|⡛⣿|⡜⣼|⡝⣿|⡞⣾|⡟⣿
⡠⣠|⡡⣧|⡢⣦|⡣⣧|⡤⣤|⡥⣧|⡦⣦|⡧⣧|⡨⣸|⡩⣿|⡪⣾|⡫⣿|⡬⣼|⡭⣿|⡮⣾|⡯⣿
⡰⣰|⡱⣷|⡲⣶|⡳⣷|⡴⣴|⡵⣷|⡶⣶|⡷⣷|⡸⣸|⡹⣿|⡺⣾|⡻⣿|⡼⣼|⡽⣿|⡾⣾|⡿⣿
⢀⢀|⢁⣇|⢂⣆|⢃⣇|⢄⣄|⢅⣇|⢆⣆|⢇⣇|⢈⢸|⢉⣿|⢊⣾|⢋⣿|⢌⣼|⢍⣿|⢎⣾|⢏⣿
⢐⢰|⢑⣷|⢒⣶|⢓⣷|⢔⣴|⢕⣷|⢖⣶|⢗⣷|⢘⢸|⢙⣿|⢚⣾|⢛⣿|⢜⣼|⢝⣿|⢞⣾|⢟⣿
⢠⢠|⢡⣧|⢢⣦|⢣⣧|⢤⣤|⢥⣧|⢦⣦|⢧⣧|⢨⢸|⢩⣿|⢪⣾|⢫⣿|⢬⣼|⢭⣿|⢮⣾|⢯⣿
⢰⢰|⢱⣷|⢲⣶|⢳⣷|⢴⣴|⢵⣷|⢶⣶|⢷⣷|⢸⢸|⢹⣿|⢺⣾|⢻⣿|⢼⣼|⢽⣿|⢾⣾|⢿⣿
⣀⣀|⣁⣇|⣂⣆|⣃⣇|⣄⣄|⣅⣇|⣆⣆|⣇⣇|⣈⣸|⣉⣿|⣊⣾|⣋⣿|⣌⣼|⣍⣿|⣎⣾|⣏⣿
⣐⣰|⣑⣷|⣒⣶|⣓⣷|⣔⣴|⣕⣷|⣖⣶|⣗⣷|⣘⣸|⣙⣿|⣚⣾|⣛⣿|⣜⣼|⣝⣿|⣞⣾|⣟⣿
⣠⣠|⣡⣧|⣢⣦|⣣⣧|⣤⣤|⣥⣧|⣦⣦|⣧⣧|⣨⣸|⣩⣿|⣪⣾|⣫⣿|⣬⣼|⣭⣿|⣮⣾|⣯⣿
⣰⣰|⣱⣷|⣲⣶|⣳⣷|⣴⣴|⣵⣷|⣶⣶|⣷⣷|⣸⣸|⣹⣿|⣺⣾|⣻⣿|⣼⣼|⣽⣿|⣾⣾|⣿⣿
`

	SpaceMW              = rune('⠀')
	FullMW               = rune('⣿')
	LeftFullMW           = rune('⡇')
	RightFullMW          = rune('⢸')
	OneThreeMW           = rune('⣸')
	CharLeft    CharType = 1 << 2
	CharRight   CharType = 1 << 1
	CharEmpty   CharType = 0
	CharFull    CharType = CharLeft + CharRight
)

var (
	MM          = Full()
	LeftOnlyMW  = []rune("⠁⠂⠄⡀⠃⡄⠆⠅⡁⡂⡆⠇⡃⡅⡇")
	RightOnlyMW = []rune("⠈⠐⠠⢀⠘⠰⠨⢈⢐⢠⢘⢨⠸⢰⢸")
)

/*
├─────────────120s├──────────────────────────60s├───────────30s├──────────────┼──────────────────────360s├─────────────────────────300s├─────────────────────────240s├─────────────────────────180s├─────────────────────────120s├──────────────────────────60s├───────────30s├──────────────┤
│                                                                             │                                                                                                                                                                                                 ⡏⠉⡇⣿⢸⢹       │
│                                                                             │                                                                                                                                                                                                 ⡇ ⢣⠃⠇⠈⡆      │
│                                                                             │                                                                                                                                                                                                 ⡇ ⠸   ⡇      │
│                                                                             │                                                                                                                                                                                                 ⡇     ⢣      │
│ MEM: 93.0GiB (6.2%)⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⠤⠤⠤⠤⠤⠤⠤⠤⠄│ AVG DCU UTL: 0.0%⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⣀⡇     ⢸⣀⣀⣀⣀⣀⡀│

*/

func Full() map[rune]rune {
	result := make(map[rune]rune)
	str := strings.ReplaceAll(strings.ReplaceAll(strings.Trim(MW, "\n"), "|", ""), "\n", "")
	runes := []rune(str)
	l := len(runes) / 2
	for i := range l {
		k := runes[2*i]
		v := runes[2*i+1]
		if k != v {
			result[k] = v
		}
	}
	return result
}

func GetCharType(r rune) CharType {
	if r == ' ' || r == SpaceMW {
		return CharEmpty
	}
	if slices.Contains(LeftOnlyMW, r) {
		return CharLeft
	}
	if slices.Contains(RightOnlyMW, r) {
		return CharRight
	}
	return CharFull
}

func CharTypeOr(a, b CharType) CharType {
	return CharType(a | b)
}
