package tui

import (
	"fmt"
	"get-container/cmd/dcutop/tchart"
	"testing"
	"time"

	"github.com/charmbracelet/lipgloss"
	"github.com/emirpasic/gods/v2/maps/linkedhashmap"
	"github.com/emirpasic/gods/v2/trees/binaryheap"
)

const S = `├───────────────────────────────┼──────────────────────┼──────────────────────┼
│ 2    BW200,            manual │ 0000:5e:00.0     Off │ Off               On │ DCU: ░░░░░░░░░░░░░░░░░░░░░░░░░   0% │`

func TestLine(t *testing.T) {
	t.Logf("%d", lipgloss.Width(S))
}

func TestHeader(t *testing.T) {
	m := ModelHeader{}
	cmd := m.Init()
	m.Update(cmd)
	fmt.Println(m.View())
}

func TestAis(t *testing.T) {
	for i := 10; i < 180; i++ {
		str := genXAxis(i)
		if lipgloss.Width(str) != i {
			t.Error("error length")
		}
		fmt.Println(str)
	}
}

func TestFormatStr(t *testing.T) {
	str := lipgloss.NewStyle().Foreground(lipgloss.Color("#2b95ffff")).SetString("hello world!").String()
	t.Logf("|%s|", FormatStr(str, 5, lipgloss.Left))
	t.Logf("|%s|", FormatStr(str, 5, lipgloss.Right))
	t.Logf("|%s|", FormatStr(str, 20, lipgloss.Left))
	t.Logf("|%s|", FormatStr(str, 20, lipgloss.Right))
}

func TestModel(t *testing.T) {
	m := NewModelMain(200, 100)
	m.Init()
	m.DCUInfo.Update(m.modelMsg)
	str := m.View()
	t.Log(str)
}

func TestMyTimeChart(t *testing.T) {
	chart := New(100, 20, 0.0, 100.0, map[string]lipgloss.Color{"default": lipgloss.Color("#ff2222ff"), "other": lipgloss.Color("#0037ffff")})
	chart.Init()
	s := chart.View()
	t.Logf("%s", s)
	time.Sleep(time.Second)
	now := time.Now()
	points := make(map[string][]tchart.TimePoint)
	points["default"] = []tchart.TimePoint{{Time: now, Value: 20.0}}
	points["other"] = []tchart.TimePoint{{Time: now, Value: 30.0}}
	chart.Update(MyTimeChartMsg{Points: points})

	_ = len(chart.dataSet)

	t.Logf("%s", chart.View())
}

func TestBinaryHeap(t *testing.T) {

	heap := binaryheap.NewWith(func(a, b time.Time) int {
		if a.After(b) {
			return 1
		}
		if a.Before(b) {
			return -1
		}
		return 0
	})
	now := time.Now()
	for i := range 5 {
		heap.Push(now.Add(time.Duration(i) * time.Second))
	}
	for {
		tt, ok := heap.Pop()
		if ok {
			t.Logf("%s", tt)
		} else {
			break
		}
	}
}

func TestLinkedHashMap(t *testing.T) {
	m := linkedhashmap.New[time.Time, int]()
	now := time.Now()
	for i := range 5 {
		m.Put(now.Add(time.Duration(i)*time.Second), 5-i)
	}
	mi := m.Iterator()
	for {
		if mi.Next() {
			t.Logf("%v: %d", mi.Key(), mi.Value())
		} else {
			break
		}
	}
	t.Log(m.Size())
}
