package backend

import (
	"testing"
	"time"

	"github.com/samber/mo"
)

func TestDcoker(t *testing.T) {
	m := DockerProcessMap{}
	start := time.Now
	err := m.Update()
	d := time.Since(start())
	if err != nil {
		t.Error(err)
	}
	t.Log(d.Nanoseconds(), "ns")
	info, l := m.Get()
	defer l.Unlock()
	for k, v := range info {
		t.Logf("%d: %+v", k, v)
	}
}

func TestUpdateQuickInfo(t *testing.T) {
	err := Init()
	if err != nil {
		t.Error(err)
	}
	defer Shutdown()
	start := time.Now()
	err = DCUSInfoMap.UpdateQuickInfo()
	du := time.Since(start)
	if err != nil {
		t.Error(err)
	}
	t.Log(du.Milliseconds(), "ms")
	info, lock := DCUSInfoMap.GetQuitInfo()
	defer lock.Unlock()
	for k, v := range info {
		t.Logf("%d: %+v", k, v)
	}
}

func BenchmarkUpdateQuickInfo(b *testing.B) {
	err := Init()
	if err != nil {
		b.Error(err)
	}
	defer Shutdown()
	b.ResetTimer()
	for i := 0; i < b.N; i++ {
		err = DCUSInfoMap.UpdateQuickInfo()
		if err != nil {
			b.Error(err)
		}
	}
}

func TestUpdateSlowInfo(t *testing.T) {
	err := Init()
	if err != nil {
		t.Error(err)
	}
	defer Shutdown()
	start := time.Now()
	err = DCUSInfoMap.UpdateSlowInfo()
	du := time.Since(start)
	if err != nil {
		t.Error(err)
	}
	t.Log(du.Milliseconds(), "ms")
	info, lock := DCUSInfoMap.GetSlowInfo()
	defer lock.Unlock()
	for k, v := range info {
		t.Logf("%d: %+v", k, v)
	}
}

func BenchmarkUpdateSlowInfo(b *testing.B) {
	err := Init()
	if err != nil {
		b.Error(err)
	}
	defer Shutdown()
	b.ResetTimer()
	for i := 0; i < b.N; i++ {
		err = DCUSInfoMap.UpdateSlowInfo()
		if err != nil {
			b.Error(err)
		}
	}
}

func TestOpt(t *testing.T) {
	o := mo.Option[int]{}
	t.Log(o.IsNone())

}