package backend

import (
	"testing"
	"time"
)

func TestUpdateDCUInfo(t *testing.T) {
	for i := 0; i < 10; i++ {
		start := time.Now()
		UpdateDCUInfo(false)
		end := time.Now()
		t.Logf("%d ms", end.Sub(start).Milliseconds())
	}
}

func TestGetDCUInfo(t *testing.T) {
	UpdateDCUInfo(true)
	info := GetDCUInfo()
	t.Logf("%+v", info)
	for i := range 10 {
		time.Sleep(time.Second)
		start := time.Now()
		UpdateDCUInfo(false)
		info = GetDCUInfo()
		tt := time.Since(start).Milliseconds()
		t.Logf("%d|%d : %+v", i, tt, info)
	}
}
