package tui

import (
	"fmt"
	"get-container/cmd/hytop/backend"
	"get-container/cmd/hytop/tchart"
	"math/rand/v2"
	"strings"
	"testing"
	"time"

	tea "github.com/charmbracelet/bubbletea"
	"github.com/charmbracelet/lipgloss"
	"github.com/charmbracelet/x/ansi"
)

func TestHeader(t *testing.T) {
	m := ModelHeader{}
	cmd := m.Init()
	m.Update(cmd)
	fmt.Println(m.View())
}

func TestAis(t *testing.T) {
	for i := 10; i < 180; i++ {
		str := genXAxis(i)
		if lipgloss.Width(str) != i {
			t.Error("error length")
		}
		fmt.Println(str)
	}
}

func TestFormatStr(t *testing.T) {
	str := lipgloss.NewStyle().Foreground(lipgloss.Color("#2b95ffff")).SetString("hello world!").String()
	t.Logf("|%s|", FormatStr(str, 5, lipgloss.Left))
	t.Logf("|%s|", FormatStr(str, 5, lipgloss.Right))
	t.Logf("|%s|", FormatStr(str, 20, lipgloss.Left))
	t.Logf("|%s|", FormatStr(str, 20, lipgloss.Right))
}

func TestModel(t *testing.T) {
	m := NewModelMain(200, 100)
	m.Init()
	m.DCUInfo.Update(m.modelMsg)
	str := m.View()
	t.Log(str)
}

func TestBinaryHeap(t *testing.T) {
	err := backend.Init()
	if err != nil {
		t.Error(err)
	}
	defer backend.Shutdown()
	main := NewModelMain(200, 60)
	c := main.Init()
	main.Update(c)
	main.View()
}

func TestSysloadInit(t *testing.T) {

	start := time.Now()
	sys := NewModelSysLoad(200)
	d := time.Since(start)
	t.Logf("%d ms", d.Milliseconds())
	start = time.Now()
	ts := sys.init()
	d = time.Since(start)
	t.Logf("%d ms", d.Milliseconds())
	for _, tt := range ts[1:] {
		t.Logf("%d ms", tt.Sub(ts[0]).Milliseconds())
	}
}

func TestTimeChart(t *testing.T) {
	chart1 := NewTimeChart(100, 20, 0, 100, nil)
	// chart2 := NewTimeChart(100, 20, 0, 100, nil)
	now := time.Now()
	points := make([]tchart.TimePoint, 0, 200)
	for i := range 200 {
		points = append(points, tchart.TimePoint{Time: now.Add(time.Duration(-i) * time.Second), Value: rand.Float64() * 100})
	}

	chart1.PutPoint(points)
	t.Logf("\n%s", chart1.View())
	chart1.ResetPutPoint(points)
	t.Logf("\n%s", chart1.View())
}

func TestFromatStr(t *testing.T) {
	style := lipgloss.NewStyle().Width(20)
	str := `hello
adfsafsfdsfsdfsfd
asd`
	ss := style.Render(str)
	for _, v := range strings.Split(ss, "\n") {
		t.Logf("w: %d", lipgloss.Width(v))
		t.Log(ansi.TruncateLeft(v,2,""))
	}
}

func TestNewProcessEnv(t *testing.T) {
	pe := NewModelProcessEnv(10, 50, 1, nil)
	
	t.Log(pe.lineNum)
	t.Log(pe.View())
	pe.Update(tea.KeyRight)
	t.Log(pe.View())
}
