package tui

import (
	"fmt"
	"get-container/gpu"
	tea "github.com/charmbracelet/bubbletea"
	"github.com/charmbracelet/lipgloss"
	"time"
)

type ModelHeader struct {
	t             time.Time
	DCUTopVersion string
	SMIVersion    string
	DriverVersion string
}

func (mh *ModelHeader) Init() tea.Cmd {
	v, err := gpu.GetHYVersionInfo()
	if err != nil || v == nil {
		return tea.Quit
	}
	mh.DCUTopVersion = "1.0.0"
	//mh.SMIVersion = v.SMIVersion       // 1.14.0
	//mh.DriverVersion = v.DriverVersion // 6.3.6-V1.9.0
	mh.SMIVersion = "1.14.0"
	mh.DriverVersion = "6.3.6-V1.9.0"
	mh.t = time.Now()
	return func() tea.Msg {
		return TickMsg(time.Now())
	}
}

func (mh *ModelHeader) Update(inputMsg tea.Msg) (tea.Model, tea.Cmd) {
	switch msg := inputMsg.(type) {
	case TickMsg:
		mh.t = time.Time(msg)
		return mh, tea.Every(time.Second, func(t time.Time) tea.Msg {
			return TickMsg(t)
		})
	}
	return mh, nil
}

func (mh *ModelHeader) View() string {
	header := fmt.Sprintf("%s                  (Press h for help or q for quit)\n", mh.t.Format("2006-01-02 15:04:05"))
	style := lipgloss.NewStyle().Width(40)
	borderStyle := lipgloss.NewStyle().Border(myBorder, true, true, false, true)
	hyv := fmt.Sprintf("hytop %s", mh.DCUTopVersion)
	drv := fmt.Sprintf("Driver Version: %s", mh.DriverVersion)
	smiv := fmt.Sprintf("SMI Version: %s", mh.SMIVersion)
	return header + borderStyle.Render(style.Render(hyv)+style.Render(drv)+style.Render(smiv)) + "\n"
}
